-- Macro_Scripts File
-- Purpose:  define action for each creatable Compound objects to hook up to the create main menu (or quads)

/*
Revision History
	July 6 2006, Pierre-Felix Breton
		Added the Pro Boolean to 3dsmax 9

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



----------------------------------------------------------------------------------------------------
macroScript Terrain 
category:~TERRAIN_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~TERRAIN_TOOLTIP~ 
buttontext:~TERRAIN_BUTTONTEXT~ 
Icon:#("Compound",4)
(
   on execute do StartObjectCreation Terrain 
   on isChecked return (mcrUtils.IsCreating Terrain)
   on isEnabled return okToCreate Terrain

)

----------------------------------------------------------------------------------------------------
macroScript Morph 
category:~MORPH_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~MORPH_TOOLTIP~ 
buttontext:~MORPH_BUTTONTEXT~ 
Icon:#("Compound",1)
(
   on execute do StartObjectCreation Morph
   on isChecked return (mcrUtils.IsCreating Morph)
   on isEnabled return okToCreate Morph

)

----------------------------------------------------------------------------------------------------
macroScript Conform 
category:~CONFORM_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~CONFORM_TOOLTIP~ 
buttontext:~CONFORM_BUTTONTEXT~ 
Icon:#("Compound",2)
(
   on execute do StartObjectCreation Conform
   on isChecked return (mcrUtils.IsCreating Conform)
   on isEnabled return okToCreate Conform
)

----------------------------------------------------------------------------------------------------
macroScript ShapeMerge 
            category:~SHAPEMERGE_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~SHAPEMERGE_TOOLTIP~ 
            buttontext:~SHAPEMERGE_BUTTONTEXT~ 
            Icon:#("Compound",3)
(
   on execute do StartObjectCreation ShapeMerge
   on isChecked return (mcrUtils.IsCreating ShapeMerge)
   on isEnabled return (okToCreate ShapeMerge)
)

----------------------------------------------------------------------------------------------------
macroScript Loft 
            category:~LOFT_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~LOFT_TOOLTIP~ 
            buttontext:~LOFT_BUTTONTEXT~ 
            Icon:#("Compound",8)
(
   on execute do StartObjectCreation Loft
   on isChecked return (mcrUtils.IsCreating Loft)
   on isEnabled return okToCreate Loft

)

----------------------------------------------------------------------------------------------------
macroScript Scatter 
            category:~SCATTER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~SCATTER_TOOLTIP~ 
            buttontext:~SCATTER_BUTTONTEXT~ 
            Icon:#("Compound",5)
(
   on execute do StartObjectCreation Scatter
   on isChecked return (mcrUtils.IsCreating Scatter)
   on isEnabled return okToCreate Scatter

)

----------------------------------------------------------------------------------------------------
macroScript Connect 
            category:~CONNECT_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~CONNECT_TOOLTIP~ 
            buttontext:~CONNECT_BUTTONTEXT~ 
            Icon:#("Compound",6)
(
    on execute do StartObjectCreation Connect
   on isChecked return (mcrUtils.IsCreating Connect)
   on isEnabled return okToCreate Connect

)

----------------------------------------------------------------------------------------------------
macroScript Boolean 
            category:~BOOLEAN_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~BOOLEAN_TOOLTIP~ 
            buttontext:~BOOLEAN_BUTTONTEXT~ 
            Icon:#("Compound",7)
(
   on execute do StartObjectCreation Boolean2
   on isChecked return (mcrUtils.IsCreating Boolean2)
   on isEnabled return okToCreate Boolean2

)

----------------------------------------------------------------------------------------------------
macroScript BlobMesh 
            category:~BLOBMESH_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~BLOBMESH_TOOLTIP~ 
            buttontext:~BLOBMESH_BUTTONTEXT~ 
            --Icon:#("Compound",5)
(
   on execute do StartObjectCreation BlobMesh 
   on isChecked return (mcrUtils.IsCreating BlobMesh )
   on isEnabled return okToCreate BlobMesh 

)

----------------------------------------------------------------------------------------------------
macroScript Mesher 
            category:~MESHER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~MESHER_TOOLTIP~ 
            buttontext:~MESHER_BUTTONTEXT~ 
            --Icon:#("Compound",5)
(
   on execute do StartObjectCreation Mesher 
   on isChecked return (mcrUtils.IsCreating Mesher )
   on isEnabled return okToCreate Mesher 

)

----------------------------------------------------------------------------------------------------
macroScript ProBoolean 
            category:~PROBOOLEAN_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~PROBOOLEAN_TOOLTIP~ 
            buttontext:"ProBoolean" 
            Icon:#("PowerBoolean",7)
(
   on execute do StartObjectCreation ProBoolean
   on isChecked return (mcrUtils.IsCreating ProBoolean)
   on isEnabled return okToCreate ProBoolean
)

----------------------------------------------------------------------------------------------------
macroScript Procutter
            category:~PROCUTTER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~PROCUTTER_TOOLTIP~ 
            buttontext:"ProCutter" 
            Icon:#("PowerBoolean",9)
(
   on execute do StartObjectCreation ProCutter
   on isChecked return (mcrUtils.IsCreating ProCutter)
   on isEnabled return okToCreate ProCutter
)

